@echo off
:: Define the parent registry key to check for SAM presence
set "parentKey=HKCU\Software\Dolphin\Sam"

:: Check if the parent key exists
reg query "%parentKey%" >nul 2>&1
if errorlevel 1 (
    echo SAM is not present on your computer.
    pause
    exit /b
)

:: Define the registry key to check/create
set "registryKey=HKCU\Software\Dolphin\Sam\EurobrailleSam"

:: Check if the registry key exists
reg query "%registryKey%" >nul 2>&1
if errorlevel 1 (
    echo The key "%registryKey%" does not exist. Creating it...
    :: Create the registry key
    reg add "%registryKey%" /f
    if errorlevel 1 (
        echo Error while creating the key "%registryKey%".
    ) else (
        echo Key "%registryKey%" created successfully. Restart Supernova, then re-run an automatic detection for EurobrailleSam.
    )
) else (
    echo The key "%registryKey%" already exists.
)
pause
